<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <!-- Superelevation Data Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Výpis výpočtu klopení</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en">Výpis výpočtu klopení</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!-- Project Data -->
                            <xsl:for-each select="RoadwayDesigner">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@fileName"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Koeficient Vstupní rastr:&#xa0; </th>
                                            <td align="left" style="font-size: 80%">
                                                <xsl:value-of select="../@inputGridScaleFactor" />
                                            </td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách,</xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech,</xsl:if>
                                                pokud není definováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <!-- Section Data -->
                                <xsl:for-each select="SuperelevationSections/SuperelevationSection">
									<hr/>
                                    <table class="margin" cellpadding="3" width="90%">
                                        <tbody>
                                            <tr>
                                                <th align="left" lang="en" width = "15%">Název sekce:&#xa0; </th>
                                                <td align="left" colspan="2">
                                                    <xsl:value-of select="@name"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" lang="en">Název trasy:&#xa0; </th>
                                                <td align="left" colspan="2">
                                                    <xsl:value-of select="@baseHorizontal"/>
                                                </td>
                                            </tr>
                                            <xsl:if test="Standards">
                                                <tr>
                                                    <th align="left" lang="en">Název souboru směrnic:&#xa0; </th>
                                                    <td align="left" colspan="2">
                                                        <xsl:value-of select="Standards/@filename"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th align="left" lang="en">Návrhová rychlost:&#xa0; </th>
                                                    <td align="left" colspan="2">
                                                        <xsl:value-of select="Standards/@designSpeed"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th align="left" lang="en">Režim otáčení:&#xa0; </th>
                                                    <td align="left" colspan="2">
                                                        <xsl:value-of select="Standards/@pivotMethod"/>
                                                    </td>
                                                </tr>
                                                <xsl:if test="Standards/@normalCrossSlope">
                                                    <tr>
                                                        <th align="left" lang="en">Sklon střechy:&#xa0; </th>
                                                        <td align="left" colspan="2">
                                                            <xsl:value-of select="cif:gradeFormat(number(Standards/@normalCrossSlope))"/>
                                                        </td>
                                                    </tr>
                                                </xsl:if>
                                                <xsl:if test="Standards/@eSelection">
                                                    <tr>
                                                        <th align="left" lang="en">E výpočet:&#xa0; </th>
                                                        <td align="left" colspan="2">
                                                            <xsl:value-of select="Standards/@eSelection"/>
                                                        </td>
                                                    </tr>
                                                </xsl:if>
                                                <xsl:if test="Standards/@lSelection">
                                                    <tr>
                                                        <th align="left" lang="en">L výpočet:&#xa0; </th>
                                                        <td align="left" colspan="2">
                                                            <xsl:value-of select="Standards/@lSelection"/>
                                                        </td>
                                                    </tr>
                                                </xsl:if>
                                                <xsl:if test="SuperelevationCalculation/@calculationUnits">
                                                    <tr>
                                                        <th align="left" lang="en">Jednotky výpočtu:&#xa0; </th>
                                                        <td align="left" colspan="2">
                                                            <xsl:value-of select="SuperelevationCalculation/@calculationUnits"/>
                                                        </td>
                                                    </tr>
                                                </xsl:if>
												<tr>
												<th align="left" lang="en">Začátek Staničení: <xsl:value-of select="cif:stationFormat(number(SuperelevationCalculation/StartStation/@externalStation), string(StartStation/@externalStationName))"/></th>
												<th align="left" lang="en">Konec Staničení: <xsl:value-of select="cif:stationFormat(number(SuperelevationCalculation/StopStation/@externalStation), string(StopStation/@externalStationName))"/></th>
											</tr>
                                            </xsl:if>
                                        </tbody>
                                    </table>
                                    <!-- Lane Set Data -->
									<hr/>
                                    <table class="margin" cellpadding="3" width="100%">
                                         <col style="width:10%"/>
                                         <col style="width:10%"/>
                                         <col style="width:10%"/>
                                         <col style="width:10%"/>
                                         <col style="width:10%"/>
                                         <col style="width:10%"/>
                                         <col style="width:10%"/>
                                         <col style="width:10%"/>
                                         <col style="width:10%"/>
                                         <col style="width:10%"/>
										<tbody>
											<xsl:for-each select="SuperelevationCalculation/LaneSets/LaneSet">
												<tr>
													<th align="left" lang="en">Sada pruhů:&#xa0; </th>
													<td align="left">
														<xsl:value-of select="@id"/>
													</td>
												</tr>
												<tr>
													<th align="left" lang="en">Levý odstup:&#xa0; </th>
													<td align="left">
														<xsl:value-of select="@leftOffset"/>
													</td>
												</tr>
												<tr>
													<th align="left" lang="en">Pravý odstup:&#xa0; </th>
													<td align="left">
														<xsl:value-of select="@rightOffset"/>
													</td>
												</tr>
												<!-- Curve Set Data -->                    
												<xsl:for-each select="CurveSets/CurveSet">
													<tr>
														<th align="left" lang="en" class="underline">Oblouk: <xsl:value-of select="@id"/></th>
														<th align="left" lang="en" class="underline">Pruh vně: <xsl:value-of select="@outsideLane"/></th>
														</tr>
													<!-- Global Variables -->												
													<xsl:if test="GlobalVariables/Variable">
														<tr>
														<td/>
															<th align="left" lang="en">Globální proměnné:</th>
														</tr>
														<xsl:for-each select="GlobalVariables/Variable">
															<tr >
																<td/>
																<td align="left">
																	<xsl:value-of select="@name"/>
																</td>
																<td align="left" >
																	<xsl:choose>
																		<xsl:when test="number(@value) = @value">
																			<xsl:value-of select="cif:formatNumber(number(@value))"/>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:value-of select="@value"/>
																		</xsl:otherwise>
																	</xsl:choose>
																</td>
															</tr>
														</xsl:for-each>
													</xsl:if>
													<!-- Max E calcs data -->
													<tr>
													<td/>
														<th align="left" lang="en" colspan="9" class="underline">Výpočet maximálního příčného sklonu</th>
													</tr>
													<tr>
														<td/>
														<th align="right" lang="en" width="10%">Max. hodnota E:&#xa0; </th>
														<td align="left">
															<xsl:value-of select="cif:gradeFormat(number(MaxECalculations/@value))"/>
														</td>
													</tr>
													<tr>
														<td/>
														<th align="right" lang="en">Výpočet dle:&#xa0; </th>
														<td align="left" colspan="8">
															<xsl:value-of select="MaxECalculations/@resultFrom"/>
														</td>
													</tr>
													<tr>
														<td/>
														<xsl:if test="MaxECalculations/@equation" >
															<th align="right" lang="en">Rovnice:&#xa0; </th>
															<td align="left" colspan="8">
																<xsl:value-of select="MaxECalculations/@equation"/>
															</td>
														</xsl:if>
													</tr>
													<xsl:if test="MaxECalculations/Variables/Variable">
														<tr>
														<td/>
														<th align="right" lang="en">Proměnné:&#xa0; </th>
														<th align="left" lang="en">Název</th>
														<th align="left" lang="en">Hodnota</th>
														<th align="left" lang="en">Rovnice</th>
													</tr>
													<xsl:for-each select="MaxECalculations/Variables/Variable">
														<tr >
															<td/>
															<td/>
															<td align="left">
																<xsl:value-of select="@name"/>
															</td>
															<td align="left">
																<xsl:choose>
																	<xsl:when test="number(@value) = @value">
																		<xsl:value-of select="cif:formatNumber(number(@value))"/>
																	</xsl:when>
																	<xsl:otherwise>
																		<xsl:value-of select="@value"/>
																	</xsl:otherwise>
																</xsl:choose>
															</td>
															<td align="left" colspan="6" >
																<xsl:value-of select="@equation"/>
															</td>
														</tr>
													</xsl:for-each>
													</xsl:if>
													<!-- Transition calcs data -->
													<tr>
														<td/>
														<th align="left" lang="en" colspan="9" class="underline">Výpočet délky přechodu:</th>
													</tr>
													<tr>
														<td/>
														<th align="right" lang="en">Délka přechodu:&#xa0; </th>
														<td align="left" colspan="8">
															<xsl:value-of select="cif:distanceFormat(number(TransitionLengthCalculations/@value))"/>
														</td>
													</tr>
													<tr>
														<td/>
														<th align="right" lang="en">Výpočet dle:&#xa0; </th>
														<td align="left" colspan="8">
															<xsl:value-of select="TransitionLengthCalculations/@resultFrom"/>
														</td>
													</tr>
													<tr>
														<xsl:if test="TransitionLengthCalculations/@equation" >
															<td/>
															<th align="right" lang="en">Rovnice:&#xa0; </th>
															<td align="left" colspan="8">
																<xsl:value-of select="TransitionLengthCalculations/@equation"/>
															</td>
														</xsl:if>
													</tr>
													<xsl:if test="TransitionLengthCalculations/Variables/Variable">	
														<tr>
														<td/>
														<th align="right" lang="en">Proměnné:&#xa0; </th>
														<th align="left" lang="en">Název</th>
														<th align="left" lang="en">Hodnota</th>
														<th align="left" lang="en" colspan="6">Rovnice</th>
													</tr>
													<xsl:for-each select="TransitionLengthCalculations/Variables/Variable">
														<tr >
														<td/>
															<td/>
															<td align="left">
																<xsl:value-of select="@name"/>
															</td>
															<td align="left">
																<xsl:choose>
																	<xsl:when test="number(@value) = @value">
																		<xsl:value-of select="cif:formatNumber(number(@value))"/>
																	</xsl:when>
																	<xsl:otherwise>
																		<xsl:value-of select="@value"/>
																	</xsl:otherwise>
																</xsl:choose>
															</td>
															<td align="left" colspan="6" >
																<xsl:value-of select="@equation"/>
															</td>
														</tr>
													</xsl:for-each>
													</xsl:if>
													<!-- Start of Curve Calcs -->
													<tr>
														<td/>
														<th align="left" lang="en" colspan="9" class="underline">Začátek oblouku Výsledky</th>
													</tr>
													<tr>
														<td/>
														<th align="right" lang="en">Předchodnice existuje:&#xa0; </th>
														<td align="left" colspan="8">
															<xsl:value-of select="StartOfCurveCalculations/@spiralExists"/>
														</td>
													</tr>
													<xsl:if test="StartOfCurveCalculations/@spiralExists='true'">
														<tr>
															<td/>
															<th align="right" lang="en">Délka přechodnice:&#xa0; </th>
															<td align="left" colspan="8">
																<xsl:value-of select="cif:distanceFormat(number(StartOfCurveCalculations/@spiralLength))"/>
															</td>
														</tr>
														<tr>
															<th align="right" lang="en" colspan="2">Přechodnice Začátek Staničení:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:stationFormat(number(StartOfCurveCalculations/StartOfSpiralStation/@externalStation), string(StartOfCurveCalculations/StartOfSpiralStation/@externalStationName))"/>
															</td>
															<th align="right" lang="en">Interní staničení:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:distanceFormat(number(StartOfCurveCalculations/StartOfSpiralStation/@internalStation))"/>
															</td>
														</tr>
													</xsl:if>
													<tr>
														<th align="right" lang="en" colspan="2">Oblouk Začátek Staničení:&#xa0; </th>
														<td align="left">
															<xsl:value-of select="cif:stationFormat(number(StartOfCurveCalculations/StartOfArcStation/@externalStation), string(StartOfCurveCalculations/StartOfArcStation/@externalStationName))"/>
														</td>
															<th align="right" lang="en">Interní staničení:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:distanceFormat(number(StartOfCurveCalculations/StartOfArcStation/@internalStation))"/>
															</td>
													</tr>
													<xsl:if test="StartOfCurveCalculations/RunoutStation">
														<tr>
															<th align="right" lang="en" colspan="2">Runout (Střecha) Staničení:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:stationFormat(number(StartOfCurveCalculations/RunoutStation/@externalStation), string(StartOfCurveCalculations/RunoutStation/@externalStationName))"/>
															</td>
															<th align="right" lang="en">Interní staničení:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:distanceFormat(number(StartOfCurveCalculations/RunoutStation/@internalStation))"/>
															</td>
														</tr>
													</xsl:if>
													<xsl:if test="StartOfCurveCalculations/RunoffStation">
														<tr>
															<th align="right" lang="en" colspan="2">Runoff (Nulový příčný sklon) Staničení:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:stationFormat(number(StartOfCurveCalculations/RunoffStation/@externalStation), string(StartOfCurveCalculations/RunoffStation/@externalStationName))"/>
															</td>
															<th align="right" lang="en">Interní staničení:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:distanceFormat(number(StartOfCurveCalculations/RunoffStation/@internalStation))"/>
															</td>
														</tr>
													</xsl:if>
													<xsl:if test="StartOfCurveCalculations/ReverseCrownStation">
														<tr>
															<th align="right" lang="en" colspan="2">Dostředný sklon Staničení:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:stationFormat(number(StartOfCurveCalculations/ReverseCrownStation/@externalStation), string(StartOfCurveCalculations/ReverseCrownStation/@externalStationName))"/>
															</td>
															<th align="right" lang="en">Interní staničení:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:distanceFormat(number(StartOfCurveCalculations/ReverseCrownStation/@internalStation))"/>
															</td>
														</tr>
													</xsl:if>
													<xsl:if test="StartOfCurveCalculations/FullSuperStation">
														<tr>
															<th align="right" lang="en" colspan="2">Plné klopení Staničení:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:stationFormat(number(StartOfCurveCalculations/FullSuperStation/@externalStation), string(StartOfCurveCalculations/FullSuperStation/@externalStationName))"/>
															</td>
															<th align="right" lang="en">Interní staničení:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:distanceFormat(number(StartOfCurveCalculations/FullSuperStation/@internalStation))"/>
															</td>
														</tr>
													</xsl:if>
													<!-- Start of curve Standard Station customization -->
													<xsl:if test="StandardStationCustomization">
														<tr>
															<td/>
															<th align="left" lang="en" colspan="9" class="underline">Začátek úpravy staničení oblouku</th>
														</tr>
														<tr>
															<td/>
															<th align="right" lang="en">Kritérium Hodnota :&#xa0; </th>
															<td align="left">
																<xsl:choose>
																	<xsl:when test="StandardStationCustomization/StartOfCurve/@criteriaEquation">
																		<xsl:value-of select="StandardStationCustomization/StartOfCurve/@criteriaValue"/>
																	</xsl:when>
																	<xsl:otherwise>
																	Ano
																	</xsl:otherwise>
																</xsl:choose>
															</td>
															<xsl:if test="StandardStationCustomization/StartOfCurve/@criteriaEquation">
																<th align="right" lang="en">Kritérium Rovnice:&#xa0; </th>
																<td align="left" colspan="5">
																	<xsl:value-of select="StandardStationCustomization/StartOfCurve/@criteriaEquation"/>
																</td>
															</xsl:if>
														</tr>
														<xsl:if test="StandardStationCustomization/StartOfCurve/RunoutStation">
														<tr>
															<th align="right" colspan="2">Runout Upravené Staničení:</th>
															<td align="left">
																<xsl:value-of select="cif:stationFormat(number(StandardStationCustomization/StartOfCurve/RunoutStation/@externalStation), string(StandardStationCustomization/StartOfCurve/RunoutStation/@externalStationName))"/>
															</td>
															<th align="right" lang="en">Interní staničení:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:distanceFormat(number(StandardStationCustomization/StartOfCurve/RunoutStation/@internalStation))"/>
															</td>
															<th align="right" lang="en">Rovnice:&#xa0;</th>
															<td align="left" colspan="4">
																<xsl:value-of select="StandardStationCustomization/StartOfCurve/RunoutStation/@equation"/>
															</td>
														</tr>
														</xsl:if>
														<xsl:if test="StandardStationCustomization/StartOfCurve/RunoffStation">
															<tr>
																<th align="right" colspan="2">Runnoff Upravené Staničení:</th>
																<td align="left">
																	<xsl:value-of select="cif:stationFormat(number(StandardStationCustomization/StartOfCurve/RunoffStation/@externalStation), string(StandardStationCustomization/StartOfCurve/RunoffStation/@externalStationName))"/>
																</td>
																<th align="right" lang="en">Interní staničení:&#xa0; </th>
																<td align="left">
																	<xsl:value-of select="cif:distanceFormat(number(StandardStationCustomization/StartOfCurve/RunoffStation/@internalStation))"/>
																</td>
																<th align="right" lang="en">Rovnice:&#xa0;</th>
																<td align="left" colspan="4">
																	<xsl:value-of select="StandardStationCustomization/StartOfCurve/RunoffStation/@equation"/>
																</td>
															</tr>
														</xsl:if>
														<xsl:if test="StandardStationCustomization/StartOfCurve/ReverseCrownStation">
															<tr>
																<th align="right" colspan="2">Dostředný sklon Upravené Staničení:</th>
																<td align="left">
																	<xsl:value-of select="cif:stationFormat(number(StandardStationCustomization/StartOfCurve/ReverseCrownStation/@externalStation), string(StandardStationCustomization/StartOfCurve/ReverseCrownStation/@externalStationName))"/>
																</td>
																<th align="right" lang="en">Interní staničení:&#xa0; </th>
																<td align="left">
																	<xsl:value-of select="cif:distanceFormat(number(StandardStationCustomization/StartOfCurve/ReverseCrownStation/@internalStation))"/>
																</td>
																<th align="right" lang="en">Rovnice:&#xa0;</th>
																<td align="left" colspan="4">
																	<xsl:value-of select="StandardStationCustomization/StartOfCurve/ReverseCrownStation/@equation"/>
																</td>
															</tr>
														</xsl:if>
														<xsl:if test="StandardStationCustomization/StartOfCurve/FullSuperStation">
															<tr>
																<th align="right" colspan="2">Plné klopení Upravené staničení:</th>
																<td align="left">
																	<xsl:value-of select="cif:stationFormat(number(StandardStationCustomization/StartOfCurve/FullSuperStation/@externalStation), string(StandardStationCustomization/StartOfCurve/FullSuperStation/@externalStationName))"/>
																</td>
																<th align="right" lang="en">Interní staničení:&#xa0; </th>
																<td align="left">
																	<xsl:value-of select="cif:distanceFormat(number(StandardStationCustomization/StartOfCurve/FullSuperStation/@internalStation))"/>
																</td>
																<th align="right" lang="en">Rovnice:&#xa0;</th>
																<td align="left" colspan="4">
																	<xsl:value-of select="StandardStationCustomization/StartOfCurve/FullSuperStation/@equation"/>
																</td>
															</tr>
														</xsl:if>
														<xsl:if test="StandardStationCustomization/StartOfCurve/Variable">	
															<tr>
															<th align="right" lang="en" colspan="2">Proměnné:&#xa0; </th>
															<th align="left" lang="en">Název</th>
															<th align="left" lang="en">Hodnota</th>
															<th align="left" lang="en" colspan="6">Rovnice</th>
															</tr>
															<tr/>
															<xsl:for-each select="StandardStationCustomization/StartOfCurve/Variable">
																<tr >
																	<td/>
																	<td/>
																	<td align="left">
																		<xsl:value-of select="@name"/>
																	</td>
																	<td align="left">
																		<xsl:choose>
																		<xsl:when test="number(@value) = @value">
																			<xsl:value-of select="cif:formatNumber(number(@value))"/>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:value-of select="@value"/>
																		</xsl:otherwise>
																	</xsl:choose>
																	</td>
																	<td align="left" colspan="6" >
																		<xsl:value-of select="@equation"/>
																	</td>
																</tr>
															</xsl:for-each>
														</xsl:if>
														<tr/>
													</xsl:if>
													<!-- End of Curve Calcs -->
													<tr>
														<td/>
														<th align="left" lang="en" colspan="9" class="underline">Konec oblouku Výsledky</th>
													</tr>
													<tr>
														<th align="right" lang="en" colspan="2">Přechodnice existuje:&#xa0; </th>
														<td align="left" colspan="8">
															<xsl:value-of select="EndOfCurveCalculations/@spiralExists"/>
														</td>
													</tr>
													<xsl:if test="EndOfCurveCalculations/@spiralExists='true'">
														<tr>
															<th align="right" lang="en" colspan="2">Délka přechodnice:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:distanceFormat(number(EndOfCurveCalculations/@spiralLength))"/>
															</td>
														</tr>
														<tr>
															<th align="right" lang="en" colspan="2">Přechodnice Konec Staničení:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:stationFormat(number(EndOfCurveCalculations/StartOfSpiralStation/@externalStation), string(EndOfCurveCalculations/StartOfSpiralStation/@externalStationName))"/>
															</td>
															<th align="right" lang="en">Interní staničení:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:distanceFormat(number(EndOfCurveCalculations/StartOfSpiralStation/@internalStation))"/>
															</td>
														</tr>
													</xsl:if>
													<tr>
														<th align="right" lang="en" colspan="2">Oblouk Konec Staničení:&#xa0; </th>
														<td align="left">
															<xsl:value-of select="cif:stationFormat(number(EndOfCurveCalculations/StartOfArcStation/@externalStation), string(EndOfCurveCalculations/StartOfArcStation/@externalStationName))"/>
														</td>
														<th align="right" lang="en">Interní staničení:&#xa0; </th>
														<td align="left">
															<xsl:value-of select="cif:distanceFormat(number(EndOfCurveCalculations/StartOfArcStation/@internalStation))"/>
														</td>
													</tr>
													<xsl:if test="EndOfCurveCalculations/FullSuperStation">
														<tr>
															<th align="right" lang="en" colspan="2">Plné klopení Staničení:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:stationFormat(number(EndOfCurveCalculations/FullSuperStation/@externalStation), string(EndOfCurveCalculations/FullSuperStation/@externalStationName))"/>
															</td>
															<th align="right" lang="en">Interní staničení:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:distanceFormat(number(EndOfCurveCalculations/FullSuperStation/@internalStation))"/>
															</td>
														</tr>
													</xsl:if>
													<xsl:if test="EndOfCurveCalculations/ReverseCrownStation">
														<tr>
															<th align="right" lang="en" colspan="2">Dostředný sklon Staničení:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:stationFormat(number(EndOfCurveCalculations/ReverseCrownStation/@externalStation), string(EndOfCurveCalculations/ReverseCrownStation/@externalStationName))"/>
															</td>
															<th align="right" lang="en">Interní staničení:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:distanceFormat(number(EndOfCurveCalculations/ReverseCrownStation/@internalStation))"/>
															</td>
														</tr>
													</xsl:if>
													<xsl:if test="EndOfCurveCalculations/RunoffStation">
														<tr>
															<th align="right" lang="en" colspan="2">Runoff (Nulový příčný sklon) Staničení:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:stationFormat(number(EndOfCurveCalculations/RunoffStation/@externalStation), string(EndOfCurveCalculations/RunoffStation/@externalStationName))"/>
															<th align="right" lang="en">Interní staničení:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:distanceFormat(number(EndOfCurveCalculations/RunoffStation/@internalStation))"/>
															</td>
															</td>
														</tr>
													</xsl:if>
													<xsl:if test="EndOfCurveCalculations/RunoutStation">
														<tr>
															<th align="right" lang="en" colspan="2">Runout (Střecha) Staničení:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:stationFormat(number(EndOfCurveCalculations/RunoutStation/@externalStation), string(EndOfCurveCalculations/RunoutStation/@externalStationName))"/>
															</td>
															<th align="right" lang="en">Interní staničení:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:distanceFormat(number(EndOfCurveCalculations/RunoutStation/@internalStation))"/>
															</td>
														</tr>
													</xsl:if>
													<!-- End Standard Station customization -->
													<xsl:if test="StandardStationCustomization">
														<tr>
															<td/>
															<th align="left" lang="en" colspan="9" class="underline">Konec úpravy staničení oblouku</th>
														</tr>
														<tr>
															<th align="right" lang="en" colspan="2">Kriterium Hodnota:&#xa0; </th>
															<td align="left">
																<xsl:choose>
																	<xsl:when test="StandardStationCustomization/EndOfCurve/@criteriaEquation">
																		<xsl:value-of select="StandardStationCustomization/EndOfCurve/@criteriaValue"/>
																	</xsl:when>
																	<xsl:otherwise>
																	Ano
																	</xsl:otherwise>
																</xsl:choose>
															</td>
															<xsl:if test="StandardStationCustomization/EndOfCurve/@criteriaEquation">
																<th align="right" lang="en">Kriterium Rovnice:&#xa0; </th>
																<td align="left" colspan="6">
																	<xsl:value-of select="StandardStationCustomization/EndOfCurve/@criteriaEquation"/>
																</td>
															</xsl:if>
														</tr>
														<xsl:if test="StandardStationCustomization/EndOfCurve/FullSuperStation">
															<tr>
																<th align="right" colspan="2">Plné klopení Upravené staničení:</th>
																<td align="left">
																	<xsl:value-of select="cif:stationFormat(number(StandardStationCustomization/EndOfCurve/FullSuperStation/@externalStation), string(StandardStationCustomization/EndOfCurve/FullSuperStation/@externalStationName))"/>
																</td>
																<th align="right" lang="en">Interní staničení:&#xa0; </th>
																<td align="left">
																	<xsl:value-of select="cif:distanceFormat(number(StandardStationCustomization/EndOfCurve/FullSuperStation/@internalStation))"/>
																</td>
																<th align="right" lang="en">Rovnice:&#xa0;</th>
																<td align="left" colspan="4">
																	<xsl:value-of select="StandardStationCustomization/EndOfCurve/FullSuperStation/@equation"/>
																</td>
															</tr>
														</xsl:if>
														<xsl:if test="StandardStationCustomization/EndOfCurve/ReverseCrownStation">
															<tr>
																<th align="right" colspan="2">Dostředný sklon Upravené Staničení:</th>
																<td align="left">
																	<xsl:value-of select="cif:stationFormat(number(StandardStationCustomization/EndOfCurve/ReverseCrownStation/@externalStation), string(StandardStationCustomization/EndOfCurve/ReverseCrownStation/@externalStationName))"/>
																</td>
																<th align="right" lang="en">Interní staničení:&#xa0; </th>
																<td align="left">
																	<xsl:value-of select="cif:distanceFormat(number(StandardStationCustomization/EndOfCurve/ReverseCrownStation/@internalStation))"/>
																</td>
																<th align="right" lang="en">Rovnice:&#xa0;</th>
																<td align="left" colspan="4">
																	<xsl:value-of select="StandardStationCustomization/EndOfCurve/ReverseCrownStation/@equation"/>
																</td>
															</tr>
														</xsl:if>
														<xsl:if test="StandardStationCustomization/EndOfCurve/RunoffStation">
															<tr>
																<th align="right" colspan="2">Runnoff Upravené Staničení:</th>
																<td align="left">
																	<xsl:value-of select="cif:stationFormat(number(StandardStationCustomization/EndOfCurve/RunoffStation/@externalStation), string(StandardStationCustomization/EndOfCurve/RunoffStation/@externalStationName))"/>
																</td>
																<th align="right" lang="en">Interní staničení:&#xa0; </th>
																<td align="left">
																	<xsl:value-of select="cif:distanceFormat(number(StandardStationCustomization/EndOfCurve/RunoffStation/@internalStation))"/>
																</td>
																<th align="right" lang="en">Rovnice:&#xa0;</th>
																<td align="left" colspan="4">
																	<xsl:value-of select="StandardStationCustomization/EndOfCurve/RunoffStation/@equation"/>
																</td>
															</tr>
														</xsl:if>
														<xsl:if test="StandardStationCustomization/EndOfCurve/RunoutStation">
														<tr>
															<th align="right" colspan="2">Runout Upravené Staničení:</th>
															<td align="left">
																<xsl:value-of select="cif:stationFormat(number(StandardStationCustomization/EndOfCurve/RunoutStation/@externalStation), string(StandardStationCustomization/EndOfCurve/RunoutStation/@externalStationName))"/>
															</td>
															<th align="right" lang="en">Interní staničení:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:distanceFormat(number(StandardStationCustomization/EndOfCurve/RunoutStation/@internalStation))"/>
															</td>
															<th align="right" lang="en">Rovnice:&#xa0;</th>
															<td align="left" colspan="4">
																<xsl:value-of select="StandardStationCustomization/EndOfCurve/RunoutStation/@equation"/>
															</td>
														</tr>
														</xsl:if>
														<xsl:if test="StandardStationCustomization/EndOfCurve/Variable">
															<tr>
															<th align="right" lang="en" colspan="2">Proměnné:&#xa0; </th>
															<th align="left" lang="en">Název</th>
															<th align="left" lang="en">Hodnota</th>
															<th align="left" lang="en" colspan="6">Rovnice</th>
															</tr>
															<xsl:for-each select="StandardStationCustomization/EndOfCurve/Variable">
																<tr >
																	<td/>
																	<td/>
																	<td align="left">
																		<xsl:value-of select="@name"/>
																	</td>
																	<td align="left">
																		<xsl:choose>
																			<xsl:when test="number(@value) = @value">
																				<xsl:value-of select="cif:formatNumber(number(@value))"/>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:value-of select="@value"/>
																			</xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td align="left" colspan="5" >
																		<xsl:value-of select="@equation"/>
																	</td>
																</tr>
															</xsl:for-each>
														</xsl:if>
													</xsl:if>
												</xsl:for-each>
												<!-- Overlap adjustments -->
												<xsl:if test="OverlapAdjustments">
													<tr>
														<th align="left" lang="en" class="underline" colspan="9">Vyrovnání přesahů</th>
													</tr>
													<xsl:for-each select="OverlapAdjustments/OverlapAdjustment">
														<tr>
															<th align="right" lang="en">První oblouk id:&#xa0;</th>
															<td>
																<xsl:value-of select="@firstCurveID"/>
															</td>
														</tr>
														<tr>
															<th align="right" lang="en">Druhý oblouk id:&#xa0;</th>
															<td>
																<xsl:value-of select="@secondCurveID"/>
															</td>
														</tr>
														<tr>
															<th align="right" lang="en">Typ vyrovnání:&#xa0;</th>
															<td>
																<xsl:value-of select="@adjustmentType"/>
															</td>
														</tr>
														<xsl:if test="@customDescription">
															<tr>
																<th align="right" lang="en">Popis:&#xa0;</th>
																<td>
																	<xsl:value-of select="@customDescription"/>
																</td>
															</tr>
														</xsl:if>
														<tr>
															<th align="right" lang="en">Střecha mezera:&#xa0;</th>
															<td>
																<xsl:value-of select="@normalCrownGap"/>
															</td>
														</tr>
														<tr>
															<th align="right" lang="en">Oblouk mezera:&#xa0;</th>
															<td>
																<xsl:value-of select="@arcGap"/>
															</td>
														</tr>
														<tr>
															<th align="center" lang="en" colspan="2">První oblouk Vyrovnání</th>
															<xsl:if test="FirstCurveAdjustments/@adjustmentAmount">
																<th align="right" lang="en">Velikost vyrovnání:&#xa0;</th>
																<td align="left">
																	<xsl:value-of select="FirstCurveAdjustments/@adjustmentAmount"/>
																</td>
															</xsl:if>
														</tr>
														<tr>
															<th align="right" lang="en" colspan="2">Konec Plné klopení Staničení:&#xa0;</th>
															<xsl:choose>
																<xsl:when test="FirstCurveAdjustments/@endFullSuperDeleted = 'true'">
																	<td align="left" lang="en">Odstraněno</td>
																</xsl:when>
																<xsl:when test="FirstCurveAdjustments/EndFullSuperStation">
																	<td align="left">
																		<xsl:value-of select="cif:stationFormat(number(FirstCurveAdjustments/EndFullSuperStation/@externalStation), string(FirstCurveAdjustments/EndFullSuperStation/@externalStationName))"/>
																	</td>
																	<th align="right" lang="en">Interní staničení:&#xa0; </th>
																	<td align="left">
																		<xsl:value-of select="cif:distanceFormat(number(FirstCurveAdjustments/EndFullSuperStation/@internalStation))"/>
																	</td>
																	<xsl:if test="FirstCurveAdjustments/EndFullSuperStation/@equation">
																		<td align="left">=</td>
																		<td align="left" colspan="4">
																			<xsl:value-of select="FirstCurveAdjustments/EndFullSuperStation/@equation"/>
																		</td>
																	</xsl:if>
																</xsl:when>
															</xsl:choose>
														</tr>
														<tr>
															<th align="right" lang="en" colspan="2">Konec Dostředný sklon Staničení:&#xa0;</th>
															<xsl:choose>
																<xsl:when test="FirstCurveAdjustments/@endReverseCrownDeleted = 'true'">
																	<td align="left" lang="en">Odstraněno</td>
																</xsl:when>
																<xsl:when test="FirstCurveAdjustments/EndReverseCrownStation">
																	<td align="left">
																		<xsl:value-of select="cif:stationFormat(number(FirstCurveAdjustments/EndReverseCrownStation/@externalStation), string(FirstCurveAdjustments/EndReverseCrownStation/@externalStationName))"/>
																	</td>
																	<th align="right" lang="en">Interní staničení:&#xa0; </th>
																	<td align="left">
																		<xsl:value-of select="cif:distanceFormat(number(FirstCurveAdjustments/EndReverseCrownStation/@internalStation))"/>
																	</td>
																	<xsl:if test="FirstCurveAdjustments/EndReverseCrownStation/@equation">
																		<td align="left">=</td>
																		<td align="left" colspan="4">
																			<xsl:value-of select="FirstCurveAdjustments/EndReverseCrownStation/@equation"/>
																		</td>
																	</xsl:if>
																</xsl:when>
															</xsl:choose>
														</tr>
														<tr>
															<th align="right" lang="en" colspan="2">Konec Nulový příčný sklon Staničení:&#xa0;</th>
															<xsl:choose>
																<xsl:when test="FirstCurveAdjustments/@endZeroCrossSlopeDeleted = 'true'">
																	<td align="left" lang="en">Odstraněno</td>
																</xsl:when>
																<xsl:when test="FirstCurveAdjustments/EndZeroCrossSlopeStation">
																	<td align="left">
																		<xsl:value-of select="cif:stationFormat(number(FirstCurveAdjustments/EndZeroCrossSlopeStation/@externalStation), string(FirstCurveAdjustments/EndZeroCrossSlopeStation/@externalStationName))"/>
																	</td>
																	<th align="right" lang="en">Interní staničení:&#xa0; </th>
																	<td align="left">
																		<xsl:value-of select="cif:distanceFormat(number(FirstCurveAdjustments/EndZeroCrossSlopeStation/@internalStation))"/>
																	</td>
																	<xsl:if test="FirstCurveAdjustments/EndZeroCrossSlopeStation/@equation">
																		<td align="left">=</td>
																		<td align="left" colspan="4">
																			<xsl:value-of select="FirstCurveAdjustments/EndZeroCrossSlopeStation/@equation"/>
																		</td>
																	</xsl:if>
																</xsl:when>
															</xsl:choose>
														</tr>
														<tr>
															<th align="right" lang="en" colspan="2">Konec Střecha Staničení:&#xa0;</th>
															<xsl:choose>
																<xsl:when test="FirstCurveAdjustments/@endNormalCrownDeleted = 'true'">
																	<td align="left" lang="en">Odstraněno</td>
																</xsl:when>
																<xsl:when test="FirstCurveAdjustments/EndNormalCrownStation">
																	<td align="left">
																		<xsl:value-of select="cif:stationFormat(number(FirstCurveAdjustments/EndNormalCrownStation/@externalStation), string(FirstCurveAdjustments/EndNormalCrownStation/@externalStationName))"/>
																	</td>
																	<th align="right" lang="en">Interní staničení:&#xa0; </th>
																	<td align="left">
																		<xsl:value-of select="cif:distanceFormat(number(FirstCurveAdjustments/EndNormalCrownStation/@internalStation))"/>
																	</td>
																	<xsl:if test="FirstCurveAdjustments/EndNormalCrownStation/@equation">
																		<td align="left">=</td>
																		<td align="left" colspan="4">
																			<xsl:value-of select="FirstCurveAdjustments/EndNormalCrownStation/@equation"/>
																		</td>
																	</xsl:if>
																</xsl:when>
															</xsl:choose>
														</tr>
														<tr>
															<th align="center" lang="en" colspan="2">Druhý oblouk Vyrovnání</th>
															<xsl:if test="SecondCurveAdjustments/@adjustmentAmount">
																<th align="right" lang="en">Velikost vyrovnání:&#xa0;</th>
																<td align="left">
																	<xsl:value-of select="SecondCurveAdjustments/@adjustmentAmount"/>
																</td>
															</xsl:if>
														</tr>
														<tr>
															<th align="right" lang="en" colspan="2">Začátek Plné klopení Staničení:&#xa0;</th>
															<xsl:choose>
																<xsl:when test="SecondCurveAdjustments/@fullSuperDeleted = 'true'">
																	<td align="left" lang="en">Odstraněno</td>
																</xsl:when>
																<xsl:when test="SecondCurveAdjustments/FullSuperStation">
																	<td align="left">
																		<xsl:value-of select="cif:stationFormat(number(SecondCurveAdjustments/FullSuperStation/@externalStation), string(SecondCurveAdjustments/FullSuperStation/@externalStationName))"/>
																	</td>
																	<th align="right" lang="en">Interní staničení:&#xa0; </th>
																	<td align="left">
																		<xsl:value-of select="cif:distanceFormat(number(SecondCurveAdjustments/FullSuperStation/@internalStation))"/>
																	</td>
																	<xsl:if test="SecondCurveAdjustments/FullSuperStation/@equation">
																		<td align="left">=</td>
																		<td align="left" colspan="4">
																			<xsl:value-of select="SecondCurveAdjustments/FullSuperStation/@equation"/>
																		</td>
																	</xsl:if>
																</xsl:when>
															</xsl:choose>
														</tr>
														<tr>
															<th align="right" lang="en" colspan="2">Začátek Dostředný sklon Staničení:&#xa0;</th>
															<xsl:choose>
																<xsl:when test="SecondCurveAdjustments/@reverseCrownDeleted = 'true'">
																	<td align="left" lang="en">Odstraněno</td>
																</xsl:when>
																<xsl:when test="SecondCurveAdjustments/ReverseCrownStation">
																	<td align="left">
																		<xsl:value-of select="cif:stationFormat(number(SecondCurveAdjustments/ReverseCrownStation/@externalStation), string(SecondCurveAdjustments/ReverseCrownStation/@externalStationName))"/>
																	</td>
																	<th align="right" lang="en">Interní staničení:&#xa0; </th>
																	<td align="left">
																		<xsl:value-of select="cif:distanceFormat(number(SecondCurveAdjustments/ReverseCrownStation/@internalStation))"/>
																	</td>
																	<xsl:if test="SecondCurveAdjustments/ReverseCrownStation/@equation">
																		<td align="left">=</td>
																		<td align="left" colspan="4">
																			<xsl:value-of select="SecondCurveAdjustments/ReverseCrownStation/@equation"/>
																		</td>
																	</xsl:if>
																</xsl:when>
															</xsl:choose>
														</tr>
														<tr>
															<th align="right" lang="en" colspan="2">Začátek Nulový příčný sklon Staničení:&#xa0;</th>
															<xsl:choose>
																<xsl:when test="SecondCurveAdjustments/@zeroCrossSlopeDeleted = 'true'">
																	<td align="left" lang="en">Odstraněno</td>
																</xsl:when>
																<xsl:when test="SecondCurveAdjustments/ZeroCrossSlopeStation">
																	<td align="left">
																		<xsl:value-of select="cif:stationFormat(number(SecondCurveAdjustments/ZeroCrossSlopeStation/@externalStation), string(SecondCurveAdjustments/ZeroCrossSlopeStation/@externalStationName))"/>
																	</td>
																	<th align="right" lang="en">Interní staničení:&#xa0; </th>
																	<td align="left">
																		<xsl:value-of select="cif:distanceFormat(number(SecondCurveAdjustments/ZeroCrossSlopeStation/@internalStation))"/>
																	</td>
																	<xsl:if test="SecondCurveAdjustments/ZeroCrossSlopeStation/@equation">
																		<td align="left">=</td>
																		<td align="left" colspan="4">
																			<xsl:value-of select="SecondCurveAdjustments/ZeroCrossSlopeStation/@equation"/>
																		</td>
																	</xsl:if>
																</xsl:when>
															</xsl:choose>
														</tr>
														<tr>
															<th align="right" lang="en" colspan="2">Začátek Střecha Staničení:&#xa0;</th>
															<xsl:choose>
																<xsl:when test="SecondCurveAdjustments/@normalCrownDeleted = 'true'">
																	<td align="left" lang="en">Odstraněno</td>
																</xsl:when>
																<xsl:when test="SecondCurveAdjustments/NormalCrownStation">
																	<td align="left">
																		<xsl:value-of select="cif:stationFormat(number(SecondCurveAdjustments/NormalCrownStation/@externalStation), string(SecondCurveAdjustments/NormalCrownStation/@externalStationName))"/>
																	</td>
																	<th align="right" lang="en">Interní staničení:&#xa0; </th>
																	<td align="left">
																		<xsl:value-of select="cif:distanceFormat(number(SecondCurveAdjustments/NormalCrownStation/@internalStation))"/>
																	</td>
																	<xsl:if test="SecondCurveAdjustments/NormalCrownStation/@equation">
																		<td align="left">=</td>
																		<td align="left" colspan="4">
																			<xsl:value-of select="SecondCurveAdjustments/NormalCrownStation/@equation"/>
																		</td>
																	</xsl:if>
																</xsl:when>
															</xsl:choose>
														</tr>
														<xsl:if test="GlobalVariables/Variable">
															<tr>
															<th align="right" lang="en" colspan="2">Proměnné:&#xa0; </th>
															<th align="left" lang="en">Název</th>
															<th align="left" lang="en">Hodnota</th>
															<th align="left" lang="en" colspan="6">Rovnice</th>
															</tr>
															<xsl:for-each select="GlobalVariables/Variable">
																<tr >
																	<td/>
																	<td/>
																	<td align="left">
																		<xsl:value-of select="@name"/>
																	</td>
																	<td align="left">
																		<xsl:choose>
																			<xsl:when test="number(@value) = @value">
																				<xsl:value-of select="cif:formatNumber(number(@value))"/>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:value-of select="@value"/>
																			</xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td align="left" colspan="5" >
																		<xsl:value-of select="@equation"/>
																	</td>
																</tr>
															</xsl:for-each>
														</xsl:if>
													</xsl:for-each>
												</xsl:if>
												<!-- Custom Key Stations -->
												<xsl:if test="CustomKeyStations">
													<tr>
														<th align="left" lang="en" class="underline" >Uživatelské staničení</th>
														<th align="right" lang="en" class="underline">Kritérium Rovnice: </th>
														<td align="left" colspan="7" class="underline">
															<xsl:choose>
																<xsl:when test="CustomKeyStations/@criteriaEquation">
																	<xsl:value-of select="CustomKeyStations/@criteriaEquation"/>
																</xsl:when>
																<xsl:otherwise>Ano</xsl:otherwise>
															</xsl:choose>
														</td>
													</tr>
													<xsl:for-each select="CustomKeyStations/CurveSets/CurveSet">
														<tr>
															<th align="left" lang="en">Sada oblouku <xsl:value-of select="@id"/></th>
														</tr>
														<tr>
															<th align="center" lang="en">Začátek oblouku</th>
															<th align="right" lang="en">Kritérium Hodnota:&#xa0;</th>
															<td align="left">
																<xsl:value-of select="StartOfCurve/@criteriaValue"/>
															</td>
														</tr>
														<xsl:for-each select="StartOfCurve/CustomStation">
														<tr>
															<th align="right" lang="en">Uživatelské staničení:&#xa0;</th>
															<td align="left" lang="en">
																<xsl:value-of select="cif:stationFormat(number(@externalStation), string(@externalStationName))"/>
															</td>
															<th align="right" lang="en">Interní staničení:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:distanceFormat(number(@internalStation))"/>
															</td>
															<td align="left" lang="en" colspan="2">
																<xsl:choose>
																	<xsl:when test="@equation">
																		= <xsl:value-of select="@equation"/>
																	</xsl:when>
																	<xsl:otherwise>
																		Interpolováno
																	</xsl:otherwise>
																</xsl:choose>
															</td>
															<th align="right" lang="en">Příčný sklon:&#xa0;</th>
															<td align="left">
																<xsl:value-of select="cif:gradeFormat(number(@crossSlopeValue))"/>
															</td>
															<td align="left" lang="en" colspan="2">
																<xsl:choose>
																	<xsl:when test="@crossSlopeEquation">
																		= <xsl:value-of select="@crossSlopeEquation"/>
																	</xsl:when>
																	<xsl:otherwise>
																		Interpolováno
																	</xsl:otherwise>
																</xsl:choose>
															</td>
														</tr>
														</xsl:for-each>
														<xsl:if test="StartOfCurve/Variable">
															<tr>
															<th align="right" lang="en" colspan="2">Proměnné:&#xa0; </th>
															<th align="left" lang="en">Název</th>
															<th align="left" lang="en">Hodnota</th>
															<th align="left" lang="en" colspan="6">Rovnice</th>
															</tr>
															<xsl:for-each select="StartOfCurve/Variable">
																<tr >
																	<td/>
																	<td/>
																	<td align="left">
																		<xsl:value-of select="@name"/>
																	</td>
																	<td align="left">
																		<xsl:choose>
																			<xsl:when test="number(@value) = @value">
																				<xsl:value-of select="cif:formatNumber(number(@value))"/>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:value-of select="@value"/>
																			</xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td align="left" colspan="5" >
																		<xsl:value-of select="@equation"/>
																	</td>
																</tr>
															</xsl:for-each>
														</xsl:if>
														<tr>
															<th align="center" lang="en">Konec oblouku</th>
															<th align="right" lang="en">Kritérium Hodnota:&#xa0;</th>
															<td align="left">
																<xsl:value-of select="EndOfCurve/@criteriaValue"/>
															</td>
														</tr>
														<xsl:for-each select="EndOfCurve/CustomStation">
														<tr>
															<th align="right" lang="en">Uživatelské staničení:&#xa0;</th>
															<td align="left" lang="en">
																<xsl:value-of select="cif:stationFormat(number(@externalStation), string(@externalStationName))"/>
															</td>
															<th align="right" lang="en">Interní staničení:&#xa0; </th>
															<td align="left">
																<xsl:value-of select="cif:distanceFormat(number(@internalStation))"/>
															</td>
															<td align="left" lang="en" colspan="2">
																<xsl:choose>
																	<xsl:when test="@equation">
																		= <xsl:value-of select="@equation"/>
																	</xsl:when>
																	<xsl:otherwise>
																		Interpolováno
																	</xsl:otherwise>
																</xsl:choose>
															</td>
															<th align="right" lang="en">Příčný sklon:&#xa0;</th>
															<td align="left">
																<xsl:value-of select="cif:gradeFormat(number(@crossSlopeValue))"/>
															</td>
															<td align="left" lang="en" colspan="2">
																<xsl:choose>
																	<xsl:when test="@crossSlopeEquation">
																		= <xsl:value-of select="@crossSlopeEquation"/>
																	</xsl:when>
																	<xsl:otherwise>
																		Interpolováno
																	</xsl:otherwise>
																</xsl:choose>
															</td>
														</tr>
														</xsl:for-each>
														<xsl:if test="EndOfCurve/Variable">
															<tr>
															<th align="right" lang="en" colspan="2">Proměnné:&#xa0; </th>
															<th align="left" lang="en">Název</th>
															<th align="left" lang="en">Hodnota</th>
															<th align="left" lang="en" colspan="6">Rovnice</th>
															</tr>
															<xsl:for-each select="EndOfCurve/Variable">
																<tr >
																	<td/>
																	<td/>
																	<td align="left">
																		<xsl:value-of select="@name"/>
																	</td>
																	<td align="left">
																		<xsl:choose>
																			<xsl:when test="number(@value) = @value">
																				<xsl:value-of select="cif:formatNumber(number(@value))"/>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:value-of select="@value"/>
																			</xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td align="left" colspan="5" >
																		<xsl:value-of select="@equation"/>
																	</td>
																</tr>
															</xsl:for-each>
														</xsl:if>
													</xsl:for-each>
												</xsl:if>
											</xsl:for-each>
                                        </tbody>
                                    </table>
                                </xsl:for-each>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Musíte nejdříve definovat klopení sekce.
            </p>
            <p class="normal1" lang="en">
                Musíte vybrat nejméně jednu sekci klopení.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>